(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      9073,        266]
NotebookOptionsPosition[      8236,        243]
NotebookOutlinePosition[      8670,        260]
CellTagsIndexPosition[      8627,        257]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", 
       RowBox[{"-", "3"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "3", ",", "0", ",", 
       RowBox[{"-", "4"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "0", ",", "5", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "5"}], ",", 
       RowBox[{"-", "2"}], ",", 
       RowBox[{"-", "3"}], ",", 
       RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MC", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"-", 
       FractionBox["5", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "5"}], "}"}], ",", 
     RowBox[{"{", 
      FractionBox["2", "3"], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Transpose", "[", 
   RowBox[{"MC", ".", 
    RowBox[{"Transpose", "[", "MC", "]"}]}], "]"}], "//", "MatrixForm"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", 
  RowBox[{"A", ",", "MC"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"3", " ", "A", " ", "BT"}], "-", 
      RowBox[{"9", "MC", " ", "MCT"}], " ", "-", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"3", "/", "2"}], "Y"}], " ", ")"}]}], "==", "0"}], ",", "Y"}],
    "]"}], 
  RowBox[{"(*", " ", 
   RowBox[{"Y", " ", "=", " ", 
    SuperscriptBox["X", "T"]}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.901967344799924*^9, 3.901967373863023*^9}, {
   3.9019674042930384`*^9, 3.90196750933502*^9}, {3.901967590266676*^9, 
   3.901967611858115*^9}, {3.90196881005923*^9, 3.90196888248335*^9}, {
   3.901969506799905*^9, 3.901969507087289*^9}, 3.9019722716010056`*^9, {
   3.9506164842806253`*^9, 3.950616514583083*^9}},
 CellLabel->"In[26]:=",ExpressionUUID->"74cdb460-2684-4d06-8549-e4e4aa686910"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      FractionBox["25", "16"], 
      FractionBox["25", "4"], 
      RowBox[{"-", 
       FractionBox["5", "6"]}]},
     {
      FractionBox["25", "4"], "25", 
      RowBox[{"-", 
       FractionBox["10", "3"]}]},
     {
      RowBox[{"-", 
       FractionBox["5", "6"]}], 
      RowBox[{"-", 
       FractionBox["10", "3"]}], 
      FractionBox["4", "9"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.9019674758887205`*^9, 3.901967501329615*^9}, {
   3.901967606623251*^9, 3.9019676124986286`*^9}, 3.901968334085184*^9, 
   3.901968883421755*^9, 3.9019689369566975`*^9, 3.9019695076924925`*^9, 
   3.901972185434937*^9, {3.901972272893219*^9, 3.9019722915445137`*^9}, 
   3.950616551499096*^9},
 CellLabel->
  "Out[29]//MatrixForm=",ExpressionUUID->"dde6bbc8-2d13-4dd3-ba67-\
03e767d79088"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"Y", "\[Rule]", 
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", " ", "BT"}], "-", 
       RowBox[{"3", " ", "MC", " ", "MCT"}]}], ")"}]}]}], "}"}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.9019674758887205`*^9, 3.901967501329615*^9}, {
   3.901967606623251*^9, 3.9019676124986286`*^9}, 3.901968334085184*^9, 
   3.901968883421755*^9, 3.9019689369566975`*^9, 3.9019695076924925`*^9, 
   3.901972185434937*^9, {3.901972272893219*^9, 3.9019722915445137`*^9}, 
   3.950616551499906*^9},
 CellLabel->"Out[31]=",ExpressionUUID->"21e1fdc8-2bd1-4fd7-8c4c-7194754f8e51"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"4", ",", "1", ",", 
       RowBox[{"-", "3"}], ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", 
       RowBox[{"-", "4"}], ",", "4", ",", 
       RowBox[{"-", "5"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "3"}], ",", "2", ",", "0", ",", 
       RowBox[{"-", "4"}]}], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"MC", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"-", 
       FractionBox["5", "4"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"-", "5"}], "}"}], ",", 
     RowBox[{"{", 
      FractionBox["2", "3"], "}"}]}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"MatrixForm", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{
    RowBox[{"2", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"A", ".", "BT"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"MC", ".", "MCT"}]}]}], ")"}]}], "/.", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"BT", "->", 
       RowBox[{"Transpose", "[", "B", "]"}]}], ",", 
      RowBox[{"MCT", "->", 
       RowBox[{"Transpose", "[", "MC", "]"}]}]}], "}"}]}], "]"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.901968271654293*^9, 3.901968321356886*^9}, {
   3.90196844895487*^9, 3.9019685354745817`*^9}, {3.9019686607322226`*^9, 
   3.901968686378374*^9}, {3.901968993383169*^9, 3.901969016207532*^9}, 
   3.90196906378316*^9, {3.9019691850166407`*^9, 3.901969195287396*^9}, {
   3.901969254755309*^9, 3.901969272379215*^9}, {3.9019693079541845`*^9, 
   3.9019693396001034`*^9}, {3.9019694024502573`*^9, 3.901969407933152*^9}, {
   3.9019694757333913`*^9, 3.901969484212443*^9}, {3.90196952561896*^9, 
   3.901969530333382*^9}, {3.901972194420474*^9, 3.9019721992717648`*^9}, {
   3.9019722819088182`*^9, 3.90197228238651*^9}, {3.9019723238046794`*^9, 
   3.90197232869003*^9}, {3.950616601297894*^9, 3.9506166178587933`*^9}},
 CellLabel->"In[40]:=",ExpressionUUID->"5f848bc5-9430-4792-aa3c-1dfbc4254bc7"],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"-", 
       FractionBox["283", "8"]}], 
      RowBox[{"-", 
       FractionBox["43", "2"]}], "49"},
     {
      FractionBox["25", "2"], 
      RowBox[{"-", "160"}], 
      RowBox[{"-", "50"}]},
     {
      RowBox[{"-", "53"}], "52", 
      FractionBox["154", "3"]}
    },
    GridBoxAlignment->{"Columns" -> {{Center}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{
  3.9019683437831526`*^9, {3.9019684765668707`*^9, 3.9019685360997515`*^9}, {
   3.90196868260316*^9, 3.901968686986342*^9}, 3.901969026980794*^9, 
   3.9019691968072987`*^9, {3.9019692586523542`*^9, 3.901969272750023*^9}, {
   3.9019693089216795`*^9, 3.901969340725954*^9}, 3.9019694083462086`*^9, 
   3.901969485233552*^9, 3.901969539940928*^9, 3.901972202074023*^9, 
   3.901972285589346*^9, 3.9019723297649145`*^9, 3.950616621917364*^9, 
   3.950618096062998*^9, 3.950618690863283*^9},
 CellLabel->
  "Out[42]//MatrixForm=",ExpressionUUID->"6b796faa-f87c-429d-9fd1-\
bf448f59f52b"]
}, Open  ]]
},
WindowSize->{1002, 502},
WindowMargins->{{-1532, Automatic}, {Automatic, 112}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.2 para Mac OS X ARM (64-bit) (December 26, 2024)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 2307, 67, 724, "Input",ExpressionUUID->"74cdb460-2684-4d06-8549-e4e4aa686910"],
Cell[2890, 91, 1225, 36, 233, "Output",ExpressionUUID->"dde6bbc8-2d13-4dd3-ba67-03e767d79088"],
Cell[4118, 129, 649, 15, 83, "Output",ExpressionUUID->"21e1fdc8-2bd1-4fd7-8c4c-7194754f8e51"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4804, 149, 2069, 53, 565, "Input",ExpressionUUID->"5f848bc5-9430-4792-aa3c-1dfbc4254bc7"],
Cell[6876, 204, 1344, 36, 258, "Output",ExpressionUUID->"6b796faa-f87c-429d-9fd1-bf448f59f52b"]
}, Open  ]]
}
]
*)

